<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1\BrandRegistration;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class BrandVettingContext extends InstanceContext {
    /**
     * Initialize the BrandVettingContext
     *
     * @param Version $version Version that contains the resource
     * @param string $brandSid A2P BrandRegistration Sid
     * @param string $brandVettingSid SID for third-party vetting record
     */
    public function __construct(Version $version, $brandSid, $brandVettingSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['brandSid' => $brandSid, 'brandVettingSid' => $brandVettingSid, ];

        $this->uri = '/a2p/BrandRegistrations/' . \rawurlencode($brandSid) . '/Vettings/' . \rawurlencode($brandVettingSid) . '';
    }

    /**
     * Fetch the BrandVettingInstance
     *
     * @return BrandVettingInstance Fetched BrandVettingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): BrandVettingInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new BrandVettingInstance(
            $this->version,
            $payload,
            $this->solution['brandSid'],
            $this->solution['brandVettingSid']
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Messaging.V1.BrandVettingContext ' . \implode(' ', $context) . ']';
    }
}